/* This file is copyright (c) 2008-2013 Philippe Fournier-Viger
* 
* This file is part of the SPMF DATA MINING SOFTWARE
* (http://www.philippe-fournier-viger.com/spmf).
* 
* SPMF is free software: you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation, either version 3 of the License, or (at your option) any later
* version.
* 
* SPMF is distributed in the hope that it will be useful, but WITHOUT ANY
* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
* A PARTICULAR PURPOSE. See the GNU General Public License for more details.
* You should have received a copy of the GNU General Public License along with
* SPMF. If not, see <http://www.gnu.org/licenses/>.
*/
package ca.pfv.spmf.algorithms.frequentpatterns.phmn_plus;

import java.util.ArrayList;
import java.util.List;

/**
 * This class represents a UtilityList as used by the HUI-Miner algorithm.
 *
 * @see AlgoHUIMiner
 * @see ElementPHMN
 * @author Philippe Fournier-Viger
 */
public class UtilityListPHMN {
	Integer item;  // the item
	long sumIutils = 0;  // the sum of item utilities
	long sumRutils = 0;  // the sum of remaining utilities
	List<ElementPHMN> elements = new ArrayList<ElementPHMN>();  // the elements
	int largestPeriodicity = 0;
	int smallestPeriodicity = Integer.MAX_VALUE;


	/**
	 * Get the periodicity of this pattern.
	 * @return the periodicity
	 */
	public int getLargestPeriodicity() {
		return largestPeriodicity;
	}

	/**
	 * Constructor.
	 * @param item the item that is used for this utility list
	 */
	public UtilityListPHMN(Integer item){
		this.item = item;
	}
	
	/**
	 * Method to add an element to this utility list and update the sums at the same time.
	 */
	public void addElement(ElementPHMN element){
		sumIutils += element.iutils;
		sumRutils += element.rutils;
		elements.add(element);
	}
	
	/**
	 * Get the support of the itemset represented by this utility-list
	 * @return the support as a number of trnsactions
	 */
	public int getSupport() {
		return elements.size();
	}
}
